//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "PreviewFrm.h"
//---------------------------------------------------------------------------
#pragma link "RVPP"
#pragma link "CRVPP"
#pragma link "RVScroll"
#pragma resource "*.dfm"
TfrmPreview *frmPreview;
//---------------------------------------------------------------------------
__fastcall TfrmPreview::TfrmPreview(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TfrmPreview::Button1Click(TObject *Sender)
{
  rvpp->First();
  Label1->Caption = Format("%d of %d", ARRAYOFCONST((rvpp->PageNo, rvpp->RVPrint->PagesCount)));
}
//---------------------------------------------------------------------------
void __fastcall TfrmPreview::Button2Click(TObject *Sender)
{
  rvpp->Prev();
  Label1->Caption = Format("%d of %d", ARRAYOFCONST((rvpp->PageNo, rvpp->RVPrint->PagesCount)));
}
//---------------------------------------------------------------------------
void __fastcall TfrmPreview::Button3Click(TObject *Sender)
{
  rvpp->Next();
  Label1->Caption = Format("%d of %d", ARRAYOFCONST((rvpp->PageNo, rvpp->RVPrint->PagesCount)));
}
//---------------------------------------------------------------------------
void __fastcall TfrmPreview::Button4Click(TObject *Sender)
{
  rvpp->Last();
  Label1->Caption = Format("%d of %d", ARRAYOFCONST((rvpp->PageNo, rvpp->RVPrint->PagesCount)));
}
//---------------------------------------------------------------------------
void __fastcall TfrmPreview::cmbExit(TObject *Sender)
{
  UpdateZoom();    
}
//---------------------------------------------------------------------------
void __fastcall TfrmPreview::cmbKeyDown(TObject *Sender, WORD &Key,
    TShiftState Shift)
{
  if (Key==VK_RETURN)
  {
    UpdateZoom();
    Key = 0;
  }
}
//---------------------------------------------------------------------------
void TfrmPreview::UpdateZoom()
{
  AnsiString s = Trim(cmb->Text);
  if (s=="Page width")
  {
    rvpp->ZoomMode = rvzmPageWidth;
    return;
  }
  if (s=="Full page")
  {
    rvpp->ZoomMode = rvzmFullPage;
    return;
  }
  if (s!="" && s[s.Length()]=='%')
    s = s.SubString(1,s.Length()-1);
  int zoom = StrToIntDef(s,0);
  if (zoom<10 || zoom>500)
    Application->MessageBox("Please enter number from 10 to 500","Scale",MB_OK | MB_ICONSTOP);
  else
    rvpp->SetZoom(zoom);
}
void __fastcall TfrmPreview::rvppZoomChanged(TObject *Sender)
{
  cmb->Text = IntToStr(rvpp->ZoomPercent)+"%";    
}
//---------------------------------------------------------------------------
